
  import ddf.minim.*;
  import java.util.*;
  
  Minim minim = new Minim(this);
  class SampleBank {
    HashMap<String, AudioSample> samples;
    AudioPlayer musicPlayer;
  
  
  
    // Constructor
    SampleBank() {
      samples = new HashMap<String, AudioSample>();
      loadAllSamples();
    }
  
    // load the background music
    void loadMusic(String musicFileName) {
      musicPlayer = minim.loadFile(musicFileName);
    }
  
    // play the background music
    void playMusic() {
      musicPlayer.play();
    }
    // make sure the music keeps playing
    void loopMusic() {
      musicPlayer.loop();
    }
  
    // Add a new sample to the sample bank
    void add(String sampleFileName) {
      AudioSample sample = minim.loadSample(sampleFileName);
      samples.put(sampleFileName, sample);
    }
  
    // trigger a loaded sample by fileName
    void trigger(String sampleFileName) {
      if (samples.containsKey(sampleFileName)) 
        samples.get(sampleFileName).trigger();
    }
  
    // trigger a loaded sample by index
    void trigger(int sampleIndex) {
      Object [] keys = samples.keySet().toArray();
      if ((sampleIndex >= 0) && (sampleIndex < keys.length))
        trigger((String) keys[sampleIndex]);
    }
  
    //load all .wav files in the processing data directory
    void loadAllSamples() {
      File dataFolder = new File(dataPath(""));
      File [] files = dataFolder.listFiles();
  
      for (File file : files)
        if (file.getName().toLowerCase().endsWith(".wav"))
          add(file.getName());
    }
  }
